/* mdNameExample.c
 *
 * Melissa Data mdName API for C++ Windows/Linux/Solaris
 * Copyright 1993-2007 Melissa Data Corporation.
 */

/********************************************************************************
If you should have any comments, suggestions or improvements to these samples,
we welcome you to contact us at SampleCode@melissadata.com also please visit our
developers bulletin board at forum.melissadata.com.
********************************************************************************/

#include <stdio.h>

#define mdCFORCE
#include "mdName.h"

/* Change the following lines to reflect your installation location */
/*   of the mdName API and the license string:                      */
#define dFILELOC "C:\\Program Files\\Melissa DATA\\COM Objects\\Data Files"
	/********************** LICENSE STRINGS **********************
	*     To unlock the full functionality of Name Object,       *
	*     	     Or to obtain a Demo License String              *
	* please call a sales representative at 1-800-MELISSA ext. 3 *
	*         (1-800-635-4772 x3) for a license string.          *
	**************************************************************/
#define dLICENSE "DEMO"

int main(int Argc,char *Argv) {
	char FullName[128];
	int Record=0;
	FILE *File;
	mdName Name;

	Argc;
	Argv;

	/* Create and initialize the API: */
	Name=mdNameCreate();
	if (!mdNameSetLicenseString(Name,dLICENSE)) {
		printf("Error setting License to \"%s\"\n",dLICENSE);
		printf("To unlock the full functionality of Name Object \n");
		printf("or to obtain a Demo License String, please call a sales representative at\n");
		printf("1-800-MELISSA ext. 3 (1-800-635-4772 x3) for a license string.\n");
		return 1;
	}

	mdNameSetPathToNameFiles(Name,dFILELOC);
	if (mdNameInitializeDataFiles(Name)!=NoError) {
		printf("Error Initializing mdName: \"%s\"\n",
			mdNameGetInitializeErrorString(Name));
		return 1;
	}

	/* Set a few processing options: */
	mdNameSetPrimaryNameHint(Name,VeryLikelyFull);
	mdNameSetFirstNameSpellingCorrection(Name,1);
	mdNameSetSalutationPrefix(Name,"Dear");
	mdNameSetSalutationSuffix(Name,":");
	mdNameSetSalutationSlug(Name,"Valued Customer");

	/* Process the sample data file: */
	File=fopen("./mdName.sdf","r");
	if (File==0) {
		printf("Could not open mdName.sdf\n");
		return 1;
	}

	while (fgets(FullName,128,File)!=0) {

		/* Trim trailing CR/LFs: */
		while (FullName[strlen(FullName)-1]=='\r' || FullName[strlen(FullName)-1]=='\n')
			FullName[strlen(FullName)-1]='\x0';

		mdNameClearProperties(Name);
		mdNameSetFullName(Name,FullName);
		mdNameParse(Name);

		printf("Record %d Full Name: %s\n            Gender1: %s\n"
		  "            Prefix1: %s\n        First Name1: %s\n"
		  "       Middle Name1: %s\n         Last Name1: %s\n"
		  "            Suffix1: %s\n            Gender2: %s\n"
		  "            Prefix2: %s\n        First Name2: %s\n"
		  "       Middle Name2: %s\n         Last Name2: %s\n"
		  "            Suffix2: %s\n         Salutation: %s\n\n",
		 ++Record,FullName,mdNameGetGender(Name),
		 mdNameGetPrefix(Name),mdNameGetFirstName(Name),
		 mdNameGetMiddleName(Name),mdNameGetLastName(Name),
		 mdNameGetSuffix(Name),mdNameGetGender2(Name),
		 mdNameGetPrefix2(Name),mdNameGetFirstName2(Name),
		 mdNameGetMiddleName2(Name),mdNameGetLastName2(Name),
		 mdNameGetSuffix2(Name),mdNameGetSalutation(Name));
	}
	fclose(File);

	/* Free the API: */
	mdNameDestroy(Name);
	return 0;
}